﻿using System;
using NUnit.Framework;
using NVCC.Models;
using System.Linq;
using System.Collections.Generic;
using NVCC.WebUI.Models;
using NVCC.WebUI.Infrastructure;

namespace NVCC.WebUI.Tests
{
    [TestFixture]
    public class ViewModelTests
    {
        IList<ProblemDiagnosis> _problemList;
        IList<Appointment> _apptList;
        IList<Lab> _labList;
          [OneTimeSetUp]
        public void TestSetUp()
        {
            _problemList = FakeDataManager.GetProblemList();
            _apptList = FakeDataManager.GetAppointmentList();
            _labList = FakeDataManager.GetLabList();
        }

          [Test]
          public void AnyListViewModel_PassNullList_ReturnsNoRecordsFoundText()
          {
              ProblemDiagnosisListViewModel result = new ProblemDiagnosisListViewModel(null);
              var expected = "NO RECORDS FOUND";
              var problemText = result.SummaryText.ToArray();
              var actual = problemText[0];
              Assert.AreEqual(expected, actual);
          }

       [Test]
        public void ProblemListViewModel_PassProblemList_ReturnsCorrectSummaryText()
        {
            ProblemDiagnosisListViewModel result = new ProblemDiagnosisListViewModel(_problemList);
            var expected = "ALOPECIA AREATA (ICD9 704.01)";
            var problemText = result.SummaryText.ToArray();
            var actual = problemText[0];
            Assert.AreEqual(expected, actual);
        }


        [Test]
        public void AppointmentListViewModel_PassApptList_ReturnsCorrectSummaryText()
        {
            AppointmentListViewModel result = new AppointmentListViewModel(_apptList);
            var expected = "01/01/2016 -- EKG OUTPT-4A103";
            var problemText = result.SummaryText.ToArray();
            var actual = problemText[0];
            Assert.AreEqual(expected, actual);
        }

        [Test]
        public void LabListViewModel_PassLabList_ReturnsCorrectSummaryText()
        {
            LabListViewModel result = new LabListViewModel(_labList);
            var expected = "Hgb   123   12/1/2015";
            var problemText = result.SummaryText.ToArray();
            var actual = problemText[0];
            Assert.AreEqual(expected, actual);
        }


        [Test]
        public void PatientProfileViewModel_PassNullObject_Returns()
        {
            PatientProfileViewModel sut = new PatientProfileViewModel();
            sut.CreateView(null);
            Assert.IsNotNull(sut);
        }

       [Test]
        public void PatientProfileViewModel_PassProblemDxList_ReturnsProblemListView()
        {
            PatientProfileViewModel sut = new PatientProfileViewModel();
            List<ProblemDiagnosis> problemDx = new List<ProblemDiagnosis>();
            sut.CreateView(problemDx);
            Assert.IsNotNull(sut.ProblemList);
        }

    }
}
